/*
 * Decompiled with CFR 0.152.
 */
package net.dragonloot.item;

import net.dragonloot.entity.DragonTridentEntity;
import net.dragonloot.init.ConfigInit;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DragonTridentItem
extends TridentItem {
    public DragonTridentItem(Item.Properties settings) {
        super(settings);
        this.f_43379_.get((Object)Attributes.f_22281_).forEach(modifier -> {
            modifier.f_22190_ = modifier.m_22218_() + (double)(ConfigInit.CONFIG.dragon_item_base_damage / 5.0f);
        });
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            int riptideLevel;
            Player playerEntity = (Player)user;
            int i = this.m_8105_(stack) - remainingUseTicks;
            if (i >= 10 && ((riptideLevel = EnchantmentHelper.m_44932_((ItemStack)stack)) <= 0 || playerEntity.m_20070_() || playerEntity.m_20077_())) {
                if (!world.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(user.m_7655_()));
                    if (riptideLevel == 0) {
                        DragonTridentEntity tridentEntity = new DragonTridentEntity(world, (LivingEntity)playerEntity, stack);
                        tridentEntity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                        if (playerEntity.m_7500_()) {
                            tridentEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        world.m_7967_((Entity)tridentEntity);
                        world.m_6269_(null, (Entity)tridentEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!playerEntity.m_7500_()) {
                            playerEntity.m_150109_().m_36057_(stack);
                        }
                    }
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (riptideLevel > 0) {
                    float f = playerEntity.m_146908_();
                    float g = playerEntity.m_146909_();
                    float h = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
                    float k = -Mth.m_14031_((float)(g * ((float)Math.PI / 180)));
                    float l = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
                    float m = Mth.m_14116_((float)(h * h + k * k + l * l));
                    float n = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                    playerEntity.m_5997_((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
                    playerEntity.m_204079_(20);
                    if (playerEntity.m_20096_()) {
                        float o = 1.1999999f;
                        playerEntity.m_6478_(MoverType.SELF, new Vec3(0.0, (double)o, 0.0));
                    }
                    SoundEvent soundEvent3 = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    world.m_6269_(null, (Entity)playerEntity, soundEvent3, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (EnchantmentHelper.m_44932_((ItemStack)itemStack) > 0 && !user.m_20070_() && !user.m_20077_()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }
}

